
VDPVRAM   EQU   $98 ;VRAM Data (Read/Write)
VDPSTATUS EQU   $99 ;VDP Status Registers

;system vars
MSXVER EQU $002D
FORCLR EQU $F3E9 ;Foreground colour
BAKCLR EQU $F3EA ;Background colour
BDRCLR EQU $F3EB ;Border colour
CLIKSW EQU $F3DB ;0 disabled / 1 enabled
RG1SAV EQU $F3E0 ;VDP REG 1
EXTVDP EQU $FFE7 ;

/*
VDPInitValues:
;set shrinked graphics 2 mode without splits of thirds
  ;db 00000010b ;graphics2, not externa video
  ;db 11000010b ;16kb,enable display,disable int,16x16sprites,mag off
  ;db 00001110b ;nametable at $3800
  ;db 10011111b ;color table at $2000-$2800 
  ;db 00000000b ;patern table 0-$0800
  ;db 01110110b  ;sprite attributes $3b00
  ;db 00000011b ;sprite pattern in vram $1800
  ;db 00000000b ;backcolor WHITE

;set standart mode 2
  ;db 00000010b ;graphics2, not externa video
  ;db 11000010b ;16kb,enable display,disable int,16x16sprites,mag off
  ;db 00001110b ;nametable at $3800
  ;db 11111111b ;color table at $2000 
  ;db 00000011b ;patern table 0-$0000
  ;db 01110110b  ;sprite attributes $3b00
  ;db 00000011b ;sprite pattern in vram $1800
  ;db 00001111b ;backcolor WHITE
*/

;-----------------------------------------------
; source: https://www.msx.org/forum/development/msx-development/how-0?page=0
; returns 1 in a and clears z flag if vdp is 60Hz
; size: 27 bytes
CheckIf60Hz:
    di
    in      a,(#99)
    nop
    nop
    nop
vdpSync:
    in      a,(#99)
    and     #80
    jr      z,vdpSync
    
    ld      hl,#900
vdpLoop:
    dec     hl
    ld      a,h
    or      l
    jr      nz,vdpLoop
    
    in      a,(#99)
    rlca
    and     1
    ei
    ld (is60),a
    
    ret

;-----------------------------------------------
; Source: (thanks to ARTRAG) https://www.msx.org/forum/msx-talk/development/memory-pages-again
; Sets the memory pages to : BIOS, ROM, ROM, RAM

HKEY:   equ #fd9a       ; hkey interrupt hook
setupROMRAMslots:
    call RSLREG     ; Reads the primary slot register
    rrca
    rrca
    and #03         ; keep the two bits for page 1
    ld c,a
    add a,#C1       
    ld l,a
    ld h,#FC        ; HL = EXPTBL + a
    ld a,(hl)
    and #80         ; keep just the most significant bit (expanded or not)
    or c
    ld c,a          ; c = a || c (a had #80 if slot was expanded, and #00 otherwise)
    inc l           
    inc l
    inc l
    inc l           ; increment 4, in order to get to the corresponding SLTTBL
    ld a,(hl)       
    and #0C         
    or c            ; in A the rom slotvar 
    ld h,#80        ; move page 1 of the ROM to page 2 in main memory
    jp ENASLT    

initGame:
  call setupROMRAMslots  
  call showIntroPicture
  call initAYFX
  ld hl,baseStatusText: ld de,statusText:ld bc,35 : ldir
  ld hl,outro4 : ld (outroString),hl

  ;disable keyboard click;CLIKSW
  xor a : ld (#F3DB),a
  

  ret

initGameplay:

  halt : call DISSCR ;disable screen
	halt : halt 

  ;init RAM variables
  ld a,GS_SHOWLEVEL: ld (gameState),a
  ld a,START_LEVEL : ld (currentLevel),a
  xor a
  ld (fireFrame),a: ld (fireDelay),a
  inc a : ld (goldDelay),a

initVDP:

  ;set colors
  ;ld a,00000000b : ld c,7 : call writeRegister
  ;set mode 2
  ;ld a,00000010b : ld c,0 : call writeRegister
  ;ld a,11000010b : ld c,1 : call writeRegister

  ;color ,5,5  
 ; ld   A,1 : ld   (BAKCLR),A
 ; ld   A,1 : ld   (BDRCLR),A  
 ; call CHGCLR
;set screen2 mode
;	ld   a,2
;	call CHGMOD  
  ;; 16x16 sprites:
  ld bc,#e201  ;; write #e2 in VDP register #01 (activate sprites, generate interrupts, 16x16 sprites with no magnification)
  call WRTVDP

  
   ;ld hl,VDPInitValues : call initVDP

   ;dill nametable with zero
   call clearScreen

   ;fill VDP memmory with tiles
   call fillVDP

   
   ret

;==========register access
;                         MSB  7   6   5   4   3   2   1   0  LSB
;                        +---+---+---+---+---+---+---+---+
;   Port #1 First byte   |D7 |D6 |D5 |D4 |D3 |D2 |D1 |D0 | DATA
;                        +===+===+===+===+===+===+===+===+
;           Second byte  | 1 | 0 |R5 |R4 |R3 |R2 |R1 |R0 | REGISTER #
;

;init VDP from HL -8 regs of vdp 
/*
initVDP8:
    ld c,0
   ld b,8
1:
    ld a,(hl) : call writeRegister
    inc hl : inc c
    djnz 1b
    ret

;a-value c -register
writeRegister:
    di
    out (#99),a
    ld a,c : add 128
    ei
    out (#99),a
    ret
  */


  ;system vars
;MSXVER     EQU $002D

;constants  
;VDPVRAM    EQU   $98 ;VRAM Data (Read/Write)
;VDPSTATUS  EQU   $99 ;VDP Status Registers

RLECONTROL EQU   $80
BASE11 EQU $2000 ;base 11 color table
BASE12 EQU $0000 ;base 12 character pattern table

;===========================================================================
; unRLEWBtoVRAM v1.1 (26 jun 2014)
; Function : Unpack WB RLE to VRAM
;     
; Input    : HL - source RAM RLE data address
;            DE - target VRAM address
;
; $80 nn dd            ; run of n consecutive identical bytes ($1>$FE), value dd
; $80 $0               ; for one $80 value
; $80 $FF              ; end of data block
; <any other value>    ; raw data             
;=========================================================================== 
unRLEWBtoVRAM:
  ; set VRAM addr 
  in    A,(VDPSTATUS)
  
  di
  ld   A,(MSXVER)
  or   A
  jr   Z,setVADDR  ;if MSX1 -> TMS9918
  ;V9938 or higher
  xor  A
  out  ($99),A
  ld   A,$8E
  out  ($99),A

setVADDR:  
  ld    A,E    
  out   (VDPSTATUS),A
  ld    A,D        
  and   $3F
  or    $40
  out   (VDPSTATUS),A
  ei
  
ANALYZE:
  ld    A,[HL]         ; get byte
  cp    RLECONTROL                      
  jr    NZ,WriteByte   ; if raw
  
  inc   HL             ; get next byte 
  ld    A,[HL]
  or    A              
  jr    Z,WriteCONTROL ;if A=0 then write one $80  ($80 $0)
  cp    $FF            ;if A=$FF ($80 $FF)
  ret   Z              ;then exit
  
  ;$80 nn dd
  inc   A              ;2 to 255
  ld    B,A            
  inc   HL
  ld    A,(HL)         ;get value
  
doRLE:
  out   (VDPVRAM),A    ;write in VRAM     
  nop
  nop
  djnz  doRLE
  
  inc   HL
  jr    ANALYZE

WriteCONTROL:
  ld    A,RLECONTROL  ;write CONTROL value
  
WriteByte:
  out   (VDPVRAM),A   ;write in VRAM
  ;nop
  inc   HL
  jr    ANALYZE


showIntroPicture:

  ;unpack picture to VRAM
	;color ,5,5  
  ld   A,1
  ld   [BAKCLR],A
  ld   A,1
  ld   [BDRCLR],A  
  call CHGCLR
	
	;screen 2
	ld   A,2
	call CHGMOD

  halt : call DISSCR ;disable screen
	halt : halt 

	halt
    ld   HL,TILESET_pat
    ld   DE,BASE12
    call  unRLEWBtoVRAM

    halt
    ld   HL,TILESET_col
    ld   DE,BASE11
    call unRLEWBtoVRAM

  halt : 	call delay :  call ENASCR ;enable screen
	halt : halt 

  ld b,254 : call haltDelay ;254
  ;halt : 	call delay : ld   A,(borderColor) : ld   (BDRCLR),A  : call CHGCLR
    call DISSCR ;disable screen
	;halt : halt 
  ;ret

showMenuPicture:


halt : call DISSCR ;disable screen
	halt : halt 

	halt
    ld   HL,mTILESET_pat
    ld   DE,BASE12
    call  unRLEWBtoVRAM

    halt
    ld   HL,mTILESET_col
    ld   DE,BASE11
    call unRLEWBtoVRAM

  call fillFontMenu
  ;clear some stuff down the rainbow
  ld hl,6144+32*13 : ld bc,768-32*13 : ld a,0 : call FILVRM
  ;ld de,0+14*256 : call draw

  ld bc,menuText : call drawString
  ld bc,menuText2 : call drawString
  ld bc,menuText3 : call drawString

  halt : 	call delay :  call ENASCR ;enable screen
	halt : halt 


    ret